<?php
/**
 * This file is part of the Cloudinary PHP package.
 *
 * (c) Cloudinary
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Cloudinary\Transformation;

/**
 * Trait AnimalObjectGravityBuilderTrait
 *
 * @api
 */
trait AnimalObjectGravityBuilderTrait
{
    /**
     * Gravity animal.
     *
     * @return string
     */
    public static function animal()
    {
        return ObjectGravity::ANIMAL;
    }

    /**
     * Gravity bird.
     *
     * @return string
     */
    public static function bird()
    {
        return ObjectGravity::BIRD;
    }

    /**
     * Gravity cat.
     *
     * @return string
     */
    public static function cat()
    {
        return ObjectGravity::CAT;
    }

    /**
     * Gravity dog.
     *
     * @return string
     */
    public static function dog()
    {
        return ObjectGravity::DOG;
    }

    /**
     * Gravity horse.
     *
     * @return string
     */
    public static function horse()
    {
        return ObjectGravity::HORSE;
    }

    /**
     * Gravity sheep.
     *
     * @return string
     */
    public static function sheep()
    {
        return ObjectGravity::SHEEP;
    }

    /**
     * Gravity cow.
     *
     * @return string
     */
    public static function cow()
    {
        return ObjectGravity::COW;
    }

    /**
     * Gravity elephant.
     *
     * @return string
     */
    public static function elephant()
    {
        return ObjectGravity::ELEPHANT;
    }

    /**
     * Gravity bear.
     *
     * @return string
     */
    public static function bear()
    {
        return ObjectGravity::BEAR;
    }

    /**
     * Gravity zebra.
     *
     * @return string
     */
    public static function zebra()
    {
        return ObjectGravity::ZEBRA;
    }

    /**
     * Gravity giraffe.
     *
     * @return string
     */
    public static function giraffe()
    {
        return ObjectGravity::GIRAFFE;
    }
}
