## Framework Version 8

See the [Versioning README](README.md) for more details on framework versions in general.

#### Breaking Changes

- A valid `redcap_csrf_token` parameter is now required on almost all POST requests, but will be automatically added behind the scenes in many cases.
  - Many module pages where the REDCap headers are included will not require any changes because the `redcap_csrf_token` parameter will automatically be added to static forms and jQuery `post()` method calls.
  - The `redcap_csrf_token` POST parameter will need to be added to dynamically generated forms, jQuery `ajax()` calls, non-jQuery javascript requests, and POST requests on pages where the REDCap headers are not included.  In those cases, the `$module->getCSRFToken()` method should be used to set the value of the `redcap_csrf_token` POST parameter.  See the `Module Development Examples` module bundled with REDCap for `getCSRFToken()` usage examples in a few different cases.  All POST requests made by module code should be tested before releasing a module update for this framework version.
  - For the very small number of pages where CSRF tokens should not be required (like custom APIs), pages can be omitted from CSRF checking by added them to `config.json` as follows (similar fashion to  `no-auth-pages`).  See the **Module Development Examples** module for an example.  Do NOT abuse this feature by using it in cases where you should be using CSRF tokens:
    
    ```
    {
        "no-csrf-pages": [
            "some-page"
        ]
    }
    ```
- If skipping framework versions, do not forget to review/address the breaking changes from all prior framework versions.
