<?php
namespace Vanderbilt\REDCap\Classes\Fhir\FhirLauncher\DTOs;

use Vanderbilt\REDCap\Classes\DTOs\DTO;

/**
 * Parameters sent via HTTP GET to the authorize endpoint
 */
final class AuthorizationRequestDTO extends DTO {
    
    const RESPONSE_TYPE_CODE = 'code';
    /**
     * This parameter must contain the value "code".
     *
     * @var string
     */
    public $response_type = AuthorizationRequestDTO::RESPONSE_TYPE_CODE;

    /**
     * This parameter contains your web application's client ID issued by Epic.
     *
     * @var string
     */
    public $client_id;

    /**
     * This parameter contains your application's redirect URI.
     * After the request completes on the Epic server, this URI will be called as a callback.
     * The value of this parameter needs to be URL encoded.
     * This URI must also be registered with the EHR's authorization server by adding it to your app listing.
     *
     * @var string
     */
    public $redirect_uri;

    /**
     * This optional parameter is generated by your app and is opaque to the EHR.
     * The EHR's authorization server will append it to each subsequent exchange in the workflow for you to validate session integrity.
     * While not required, this parameter is recommended to be included and validated with each exchange in order to increase security.
     * For more information see RFC 6819 Section 3.6.
     *
     * @var string
     */
    public $state;

    /**
     * This parameter describes the information for which the web application is requesting access.
     * Starting with the November 2019 version of Epic, the "openid" and "fhirUser" OpenID Connect scopes are supported.
     * Starting with the February 2021 version of Epic, the "profile" scope is also supported.
     * Starting with the May 2021 release of Epic, apps can request a launch context (e.g.
     * patient or encounter) with scope.
     *
     * @var string
     */
    public $scope;

    /**
     * Starting in the August 2021 version of Epic, health care organizations can optionally configure their system to require the aud parameter for Standalone and EHR launch workflows if a launch context is included in the scope parameter.
     * Starting in the November 2022 version of Epic, this parameter will be required.
     * The value to use is the base URL of the resource server the application intends to access, which is typically the FHIR server.
     *
     * @var string
     */
    public $aud;

    /**
     * This optional parameter forces the authentication to use the legacy OAuth2 login for cases where the HSWeb login is not supported (the browser shows an unsupported browser message).
     *
     * @var string
     */
    public $legacy_login_page;

    /**
     * This parameter is required for EHR launch workflows.
     * The value to use will be passed from the EHR.
     *
     * @var string
     */
    public $launch;

    /**
     * This optional parameter can be used if the "openid" scope is specified.
     * It associates the client session with the specified ID token.
     * For more information about the nonce, refer to the Authentication Request section of the OpenID specification.
     *
     * @var string
     */
    public $nonce;

    /**
     * This optional parameter is generated by your app and used for PKCE.
     * This is the S256 hashed version of the code_verifier parameter,
     * which will be used in the token request.
     *
     * @var string
     */
    public $code_challenge;

    /**
     * This optional parameter indicates the method used for the
     * code_challenge parameter and is required if using that parameter.
     * Currently, only the S256 method is supported (Epic) .
     *
     * @var string
     */
    public $code_challenge_method;



}