// vite.config.js
import { defineConfig } from 'vite'
import { resolve } from 'path'
import { fileURLToPath, URL } from 'node:url'
import vue from '@vitejs/plugin-vue'

import path from 'path';

// Get the relative folder path where the build is run
const currentPath = path.basename(process.cwd()); // Extracts current

const fullPath = path.resolve(__dirname);
const pathParts = fullPath.split(path.sep); // Split by system's path separator
const relativePath = pathParts.slice(-4).join(path.sep); // Get the meaningful parts

const outDir = 'dist-demo'

export default defineConfig({
    build: {
        outDir: `${outDir}`, // Default folder for the standard build
        manifest: true,
        cssCodeSplit: true,
        rollupOptions: {
            input: {
                demo: resolve(__dirname, 'demo/main.js'), // Entry point for Modal composable
                // Add more entry points for other composables as needed
            },
            // output: {
            //     dir: 'dist',
            //     entryFileNames: 'js/[name]-[hash].js',      // Output JavaScript files
            //     chunkFileNames: 'js/[name]-[hash].js',
            //     assetFileNames: (assetInfo) => {
            //         const assets = []
            //         assetInfo.names.forEach(name => {
            //             if (name.endsWith('.css')) {
            //                 assets.push('css/[name]-[hash][extname]'); // Output CSS files
            //             }
            //             else assets.push('assets/[name]-[hash][extname]');
            //         })
            //         return assets.join('-')
            //     },
            // },
        },
    },
    resolve: {
        alias: {
            '@': fileURLToPath(new URL('./src', import.meta.url)),
        },
    },
    plugins: [vue()],
});