<?php

/**
 * Extend FPDF to add WriteHTML function
 */
class FPDF_HTML extends FPDF 
{
	function WriteHTML($html) {
		//HTML parser
		$html=str_replace("\n",' ',$html);
		$a=preg_split('/<(.*)>/U',$html,-1,PREG_SPLIT_DELIM_CAPTURE);
		foreach($a as $i=>$e) {
			if($i%2==0) {
				//Text
				// if($this->HREF)
				// $this->PutLink($this->HREF,$e);
				// else
				if (USE_UTF8) {
					$this->Write(8,$e);
				} else {
					$this->Write(5,$e);
				}
			}
			else {
				//Tag
				if($e[0]=='/')
					$this->CloseTag(strtoupper(substr($e,1)));
				else {
					//Extract attributes
					$a2=explode(' ',$e);
					$tag=strtoupper(array_shift($a2));
					$attr=array();
					foreach($a2 as $v) {
						if(preg_match('/([^=]*)=["\']?([^"\']*)/',$v,$a3))
							$attr[strtoupper($a3[1])]=$a3[2];
					}
					$this->OpenTag($tag,$attr);
				}
			}
		}
	}

	function OpenTag($tag,$attr) {
		//Opening tag
		if($tag=='B' || $tag=='I' || $tag=='U')
			$this->SetStyle($tag,true);
		if($tag=='A')
			$this->HREF=$attr['HREF'];
		if($tag=='BR')
			$this->Ln(5);
	}

	function CloseTag($tag) {
		//Closing tag
		if($tag=='B' || $tag=='I' || $tag=='U')
			$this->SetStyle($tag,false);
		if($tag=='A')
			$this->HREF='';
	}

	function SetStyle($tag,$enable) {
		//Modify style and select corresponding font
		$this->$tag+=($enable ? 1 : -1);
		$style='';
		foreach(array('B','I','U') as $s) {
			if($this->$s>0)
				$style.=$s;
		}
		$this->SetFont('',$style);
	}

	function PutLink($URL,$txt) {
		//Put a hyperlink
		$this->SetTextColor(0,0,255);
		$this->SetStyle('U',true);
		if (USE_UTF8) {
			$this->Write(8,$txt,$URL);
		} else {
			$this->Write(5,$txt,$URL);
		}
		$this->SetStyle('U',false);
		$this->SetTextColor(0);
	}

	function AddMBFont($family='',$enc='')
	{
		global $MBTTFDEF,$MBCMAP;
		$gt=$MBTTFDEF;
		$gc=$MBCMAP;
		if ($enc == '' || isset($gc[$enc]) == false) {
			die("AddMBFont: ERROR Encoding [$enc] Undefine.");
		}
		if (isset($gt[$family])) {
			$ut=$gt[$family]['ut'];
			$up=$gt[$family]['up'];
			$cw=$gt[$family]['cw'];
			$cm=$gc[$enc]['CMap'];
			$od=$gc[$enc]['Ordering'];
			$sp=$gc[$enc]['Supplement'];
			$registry=array('ordering'=>$od,'supplement'=>$sp);
			$this->AddCIDFont($family,''  ,"$family"           ,$cw,$cm,$registry,$ut,$up);
			$this->AddCIDFont($family,'B' ,"$family,Bold"      ,$cw,$cm,$registry,$ut,$up);
			$this->AddCIDFont($family,'I' ,"$family,Italic"    ,$cw,$cm,$registry,$ut,$up);
			$this->AddCIDFont($family,'BI',"$family,BoldItalic",$cw,$cm,$registry,$ut,$up);
		} else {
			die("AddMBFont: ERROR FontName [$family] Undefine.");
		}
	}
}