-- Change the project_id value on the next line to match the one for your DDP project.
set @project_id = XX;

-- Do NOT change anything below this line.
delete from redcap_ddp_mapping where project_id = @project_id;
delete from redcap_ddp_preview_fields where project_id = @project_id;
set @event_id = (select event_id from redcap_events_metadata m, redcap_events_arms a where a.arm_id = m.arm_id and a.project_id = @project_id order by a.arm_num, m.day_offset, m.descrip limit 1);
INSERT INTO redcap_ddp_preview_fields (project_id, field1, field2, field3, field4, field5) VALUES
(@project_id, 'firstName', 'lastName', 'dob', NULL, NULL);
INSERT INTO redcap_ddp_mapping (external_source_field_name, is_record_identifier, project_id, event_id, field_name, temporal_field, preselect) VALUES
('mrn', 1, @project_id, @event_id, 'mrn', NULL, NULL),
('dob', NULL, @project_id, @event_id, 'dob', NULL, NULL),
('ethnicity', NULL, @project_id, @event_id, 'ethnicity', NULL, NULL),
('firstName', NULL, @project_id, @event_id, 'first_name', NULL, NULL),
('gender', NULL, @project_id, @event_id, 'sex', NULL, NULL),
('lastName', NULL, @project_id, @event_id, 'last_name', NULL, NULL),
('race', NULL, @project_id, @event_id, 'race', NULL, NULL),
('Creat', NULL, @project_id, @event_id, 'creat', 'visit_date', 'LAST'),
('Gluc', NULL, @project_id, @event_id, 'gluc', 'visit_date', 'MAX'),
('K', NULL, @project_id, @event_id, 'k', 'visit_date', NULL),
('Na', NULL, @project_id, @event_id, 'na', 'visit_date', NULL);